/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.test;

import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.api.WSBinding;
import filenet.ws.api.WSBindingInput;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSBindingOutput;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMIMEPart;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSOperation;
import filenet.ws.api.WSPort;
import filenet.ws.api.WSPortType;
import filenet.ws.api.WSService;
import filenet.ws.api.WSSoapHeader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Message;
import javax.wsdl.Port;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPUrlEncoded;
import javax.wsdl.extensions.http.HTTPUrlReplacement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMimeXml;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.BaseType;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionType;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.PortEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;

public class WSWSDLParser {
    private WSDefinition m_definition = null;

    public void testGeneratWSDLFromWorkflow() throws Exception {
    }

    public void exploreDefinition(String wsdlURL) throws Exception {
        WSDefinition definition = new WSDefinition(wsdlURL);
        this.exploreDefinition(new WSDefinition(wsdlURL));
        this.exploreMessageSchemas(definition);
        WSWSDLParser.println("**************************************************", 0);
        this.getNameSpaces();
        WSWSDLParser.println("**************************************************", 0);
        WSWSDLParser.println("**************************************************", 0);
        this.explorePortTypes();
        WSWSDLParser.println("**************************************************", 0);
        this.exploreServices();
    }

    public void exploreDefinition(WSDefinition definition) throws Exception {
        this.m_definition = definition;
        this.exploreMessageSchemas(definition);
        WSWSDLParser.println("**************************************************", 0);
        this.getNameSpaces();
        WSWSDLParser.println("**************************************************", 0);
        WSWSDLParser.println("**************************************************", 0);
        this.explorePortTypes();
        WSWSDLParser.println("**************************************************", 0);
        this.exploreServices();
    }

    private void definitionBuilderTest() throws Exception {
    }

    private void getNameSpaces() {
        String[] s = null;
        Object temp = null;
        s = this.m_definition.getNameSpaces();
        if (s != null && s.length > 0) {
            String prefix = null;
            for (int i = 0; i < s.length; ++i) {
                if (s[i] == null) continue;
                prefix = this.m_definition.getNamespacePrefix(s[i]);
                if (prefix == null || prefix.length() == 0) {
                    WSWSDLParser.println(s[i], 0);
                    continue;
                }
                WSWSDLParser.println(prefix + "=" + s[i], 0);
            }
        }
    }

    private void explorePortTypes() throws Exception {
        WSPortType[] portTypes = this.m_definition.getPortTypes();
        if (portTypes != null && portTypes.length > 0) {
            WSPortType portType = null;
            for (int i = 0; i < portTypes.length; ++i) {
                portType = portTypes[i];
                if (portType == null) continue;
                WSWSDLParser.println("\n*** PortType " + portType.getDisplayName(), 0);
                WSOperation[] operations = portType.getOperations();
                if (operations == null || operations.length <= 0) continue;
                WSOperation operation = null;
                String[] namespaces = null;
                for (int j = 0; j < operations.length; ++j) {
                    operation = operations[j];
                    WSWSDLParser.println("------ Operation " + operation.getDisplayName(), 1);
                    WSWSDLParser.println("In msg", 1);
                    WSMessage inMsg = operation.getInMessage();
                    if (inMsg != null) {
                        // empty if block
                    }
                    WSWSDLParser.println(operation.getExpressionInMessageTemplate(), 2);
                    WSWSDLParser.println(operation.getXMLInMessageTemplate(), 2);
                    namespaces = operation.getInMessageNameSpaces();
                    if (namespaces != null && namespaces.length > 0) {
                        WSWSDLParser.println("In msg namespaces", 1);
                        for (int k = 0; k < namespaces.length; ++k) {
                            WSWSDLParser.println(namespaces[k], 2);
                        }
                    }
                    WSWSDLParser.println("Out msg", 1);
                    WSMessage outMsg = operation.getOutMessage();
                    if (outMsg != null) {
                        // empty if block
                    }
                    WSWSDLParser.println(operation.getXMLOutMessageTemplate(), 2);
                    namespaces = operation.getOutMessageNameSpaces();
                    if (namespaces != null && namespaces.length > 0) {
                        WSWSDLParser.println("Out msg namespaces", 1);
                        for (int k = 0; k < namespaces.length; ++k) {
                            WSWSDLParser.println(namespaces[k], 2);
                        }
                    }
                    WSWSDLParser.println("Faults", 1);
                    String[] faults = operation.getFaultTemplates();
                    if (faults == null || faults.length <= 0) continue;
                    for (int k = 0; k < faults.length; ++k) {
                        WSWSDLParser.println(faults[k], 2);
                    }
                }
            }
        }
    }

    private void exploreMessageSchemas(WSDefinition definition) {
    }

    private void exploreServices() throws Exception {
        block4: {
            block3: {
                WSService[] services = this.m_definition.getServices();
                if (services == null || services.length <= 0) break block3;
                for (int i = 0; i < services.length; ++i) {
                    if (services[i] == null) continue;
                    System.out.println("\n=====================================================\n");
                    System.out.println("Service: " + services[i].getDisplayName());
                    System.out.println("=====================================================\n");
                    WSPort[] ports = services[i].getPorts();
                    if (ports == null || ports.length <= 0) continue;
                    for (int j = 0; j < ports.length; ++j) {
                        if (ports[j] == null) continue;
                        System.out.println("=====================================================\n");
                        System.out.println("\nPort: " + ports[j].getDisplayName());
                        WSBinding binding = ports[j].getBinding();
                        this.exploreBinding(binding);
                    }
                }
                break block4;
            }
            WSBinding[] bindings = this.m_definition.getBindings();
            if (bindings == null || bindings.length <= 0) break block4;
            for (int i = 0; i < bindings.length; ++i) {
                this.exploreBinding(bindings[i]);
            }
        }
    }

    private void exploreBinding(WSBinding binding) throws Exception {
        if (binding != null) {
            WSBindingOperation[] bindingOperations = binding.getBindingOperations();
            System.out.println("\nBinding: " + binding.getDisplayName() + ", # ops=" + (bindingOperations == null ? "0" : Integer.toString(bindingOperations.length)));
            if (bindingOperations != null && bindingOperations.length > 0) {
                for (int k = 0; k < bindingOperations.length; ++k) {
                    WSBindingOutput bindingOutput;
                    WSBindingInput bindingInput;
                    String result;
                    if (bindingOperations[k] == null) continue;
                    System.out.println("+++++++++++++++++++++++++++++++++++++++");
                    System.out.println("Binding operation: " + bindingOperations[k].getDisplayName());
                    if (bindingOperations[k].isSoapBinding()) {
                        System.out.println("\nSoapBinding");
                        System.out.println("\nSoapStyle: = " + bindingOperations[k].getSoapStyle());
                        System.out.println("\nSoapAction: = " + bindingOperations[k].getSoapAction());
                    }
                    System.out.println("In params (getInParamTemplate)");
                    System.out.println(bindingOperations[k].getInParamTemplate());
                    String inXMLTemplate = bindingOperations[k].getXMLInParamTemplate();
                    if (inXMLTemplate != null && (result = bindingOperations[k].addedBindingInfoToInParam(inXMLTemplate)).compareTo(inXMLTemplate) != 0) {
                        System.out.println();
                        System.out.println("In params (addedBindingInfoToInParam)");
                        System.out.println(result);
                    }
                    System.out.println();
                    System.out.println("In headers (getSoapInHeaders)");
                    WSSoapHeader[] soapInHeaders = bindingOperations[k].getSoapInHeaders();
                    if (soapInHeaders != null && soapInHeaders.length > 0) {
                        int kk;
                        System.out.println("In header templates (getTemplate)");
                        for (kk = 0; kk < soapInHeaders.length; ++kk) {
                            System.out.println(soapInHeaders[kk].getTemplate());
                        }
                        System.out.println("In header message namespace (getMessageNamespaces)");
                        for (kk = 0; kk < soapInHeaders.length; ++kk) {
                            String[] namespaces = soapInHeaders[kk].getMessageNamespaces();
                            if (namespaces == null) continue;
                            for (int idx = 0; idx < namespaces.length; ++idx) {
                                System.out.println(namespaces[idx]);
                            }
                        }
                    }
                    if ((bindingInput = bindingOperations[k].getBindingInput()) != null) {
                        WSMIMEPart[] mimeParts;
                        Object[] mimeElements = bindingInput.getMimeElements();
                        if (mimeElements != null && mimeElements.length > 0) {
                            WSWSDLParser.println("MIME elements", 0);
                            for (int kk = 0; kk < mimeElements.length; ++kk) {
                                if (mimeElements[kk] == null) continue;
                                System.out.println("index= " + kk);
                                System.out.println(mimeElements[kk]);
                            }
                        }
                        if ((mimeParts = bindingInput.getMimeParts()) != null && mimeParts.length > 0) {
                            WSWSDLParser.println("MIME parts", 0);
                            for (int kk = 0; kk < mimeParts.length; ++kk) {
                                WSWSDLParser.println(kk + ": " + mimeParts[kk].toString(), 0);
                            }
                        }
                        String[] encodingStyles = bindingInput.getSoapBodyEncodingStyles();
                        String[] parts = bindingInput.getSoapBodyParts();
                    }
                    System.out.println();
                    System.out.println("Out param (getOutParamTemplate)");
                    System.out.println(bindingOperations[k].getOutParamTemplate());
                    System.out.println();
                    System.out.println("Out headers (getSoapOutHeaders)");
                    WSSoapHeader[] soapOutHeaders = bindingOperations[k].getSoapOutHeaders();
                    if (soapOutHeaders != null && soapOutHeaders.length > 0) {
                        int kk;
                        System.out.println("Out header templates (getTemplate)");
                        for (kk = 0; kk < soapOutHeaders.length; ++kk) {
                            System.out.println(soapOutHeaders[kk].getTemplate());
                        }
                        System.out.println("Out header message namespaces (getMessageNamespaces)");
                        for (kk = 0; kk < soapOutHeaders.length; ++kk) {
                            String[] namespaces = soapOutHeaders[kk].getMessageNamespaces();
                            if (namespaces == null) continue;
                            for (int idx = 0; idx < namespaces.length; ++idx) {
                                System.out.println(namespaces[idx]);
                            }
                        }
                    }
                    if ((bindingOutput = bindingOperations[k].getBindingOutput()) != null) {
                        WSMIMEPart[] mimeParts;
                        Object[] mimeElements = bindingOutput.getMimeElements();
                        if (mimeElements != null && mimeElements.length > 0) {
                            WSWSDLParser.println("MIME elements", 0);
                            for (int kk = 0; kk < mimeElements.length; ++kk) {
                                if (mimeElements[kk] == null) continue;
                                System.out.println("index= " + kk);
                                System.out.println(mimeElements[kk]);
                            }
                        }
                        if ((mimeParts = bindingOutput.getMimeParts()) != null && mimeParts.length > 0) {
                            WSWSDLParser.println("Mime parts", 0);
                            for (int kk = 0; kk < mimeParts.length; ++kk) {
                                WSWSDLParser.println(kk + ": " + mimeParts[kk].toString(), 0);
                            }
                        }
                    }
                    System.out.println();
                    String[] s = bindingOperations[k].getFaultTemplates();
                    if (s != null) {
                        System.out.println("Faults (getFaultTemplates)");
                        for (int index = 0; index < s.length; ++index) {
                            System.out.println(s[index] + "\n");
                        }
                    }
                    System.out.println();
                }
            }
        }
    }

    private void exploreExtensibilityElements(List l, int spaces) {
        if (l != null && l.size() > 0) {
            Object obj = null;
            for (int i = 0; i < l.size(); ++i) {
                SOAPAddress e;
                MIMEContent m;
                obj = l.get(i);
                if (obj == null) continue;
                WSWSDLParser.println(obj.toString(), spaces);
                ++spaces;
                if (obj instanceof SOAPHeader) {
                    SOAPHeader soapHeader = (SOAPHeader)obj;
                    Message msg = this.m_definition.getMessage(soapHeader.getMessage()).getMessage();
                    WSWSDLParser.println("SOAPHeader: " + soapHeader.toString(), spaces);
                } else if (obj instanceof MIMEContent) {
                    m = (MIMEContent)obj;
                    WSWSDLParser.println("MIMEContent: " + m.toString(), spaces);
                } else if (obj instanceof MIMEMimeXml) {
                    m = (MIMEMimeXml)obj;
                    WSWSDLParser.println("MIMEMimeXml: " + m.toString(), spaces);
                } else if (obj instanceof SOAPAddress) {
                    e = (SOAPAddress)obj;
                    WSWSDLParser.println("SOAPAddress: " + e.toString(), spaces);
                } else if (obj instanceof SOAPBinding) {
                    e = (SOAPBinding)obj;
                    WSWSDLParser.println("SOAPBinding: " + e.toString(), spaces);
                } else if (obj instanceof SOAPBody) {
                    e = (SOAPBody)obj;
                    WSWSDLParser.println("SOAPBody: " + e.toString(), spaces);
                } else if (obj instanceof SOAPFault) {
                    e = (SOAPFault)obj;
                    WSWSDLParser.println("SOAPFault: " + e.toString(), spaces);
                } else if (obj instanceof SOAPHeaderFault) {
                    e = (SOAPHeaderFault)obj;
                    WSWSDLParser.println("SOAPHeaderFault: " + e.toString(), spaces);
                } else if (obj instanceof SOAPOperation) {
                    e = (SOAPOperation)obj;
                    WSWSDLParser.println("SOAPOperation: " + e.toString(), spaces);
                } else if (obj instanceof HTTPAddress) {
                    e = (HTTPAddress)obj;
                    WSWSDLParser.println("HTTPAddress: " + e.toString(), spaces);
                } else if (obj instanceof HTTPBinding) {
                    e = (HTTPBinding)obj;
                    WSWSDLParser.println("HTTPBinding: " + e.toString(), spaces);
                } else if (obj instanceof HTTPUrlEncoded) {
                    e = (HTTPUrlEncoded)obj;
                    WSWSDLParser.println("HTTPUrlEncoded: " + e.toString(), spaces);
                } else if (obj instanceof HTTPUrlReplacement) {
                    e = (HTTPUrlReplacement)obj;
                    WSWSDLParser.println("HTTPUrlReplacement: " + e.toString(), spaces);
                } else if (obj instanceof MIMEMultipartRelated) {
                    e = (MIMEMultipartRelated)obj;
                    WSWSDLParser.println("MIMEMultipartRelated: " + e.toString(), spaces);
                } else if (obj instanceof MIMEPart) {
                    e = (MIMEPart)obj;
                    WSWSDLParser.println("MIMEPart: " + e.toString(), spaces);
                } else if (obj instanceof HTTPUrlEncoded) {
                    e = (HTTPUrlEncoded)obj;
                    WSWSDLParser.println("HTTPUrlEncoded: " + e.toString(), spaces);
                } else if (obj instanceof UnknownExtensibilityElement) {
                    e = (UnknownExtensibilityElement)obj;
                    WSWSDLParser.println("UnknownExtensibilityElement: " + e.toString(), spaces);
                } else {
                    WSWSDLParser.println("Unknow extensibility element type", spaces);
                }
                --spaces;
            }
        }
    }

    private String getIndentationString(int level) {
        String s = new String();
        for (int i = 0; i < level; ++i) {
            s = s + "  ";
        }
        return s;
    }

    private static void println(String s, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            System.out.print(" ");
        }
        System.out.println(s);
    }

    private static void print(String s, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            System.out.print(" ");
        }
        System.out.print(s);
    }

    public static void main(String[] args) throws Exception {
        VWCommandLineArgs c = new VWCommandLineArgs(args);
        if (c.isPresent("h") || c.isPresent("?") || c.isPresent("H")) {
            System.out.println("WSWSDLParser [/url=WSDLURL] [/wf2wsdl]");
            System.exit(0);
        }
        if (c.isPresent("inputfile")) {
            String inputFile = c.getParameter("inputfile");
            c = new VWCommandLineArgs(inputFile, false);
        }
        try {
            String URL2 = c.getParameter("url", null);
            System.out.println("Exploring " + URL2);
            WSWSDLParser parser = new WSWSDLParser();
            if (URL2 != null) {
                System.out.println("EXPLORE DEFINITION  -----------------------");
                parser.exploreDefinition(URL2);
                System.out.println("EXPLORE MESSAGE SCHEMAS -----------------------");
                parser.exploreMessageSchemas(new WSDefinition(URL2));
            }
            if (c.isPresent("wf2wsdl")) {
                System.out.println("TEST GENERATEWSDL FROM WORKFLOW -------------------");
                parser.testGeneratWSDLFromWorkflow();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    public SymTabEntry getSymTabEntry(QName qname, Class cls) {
        HashMap map = this.m_definition.getParser().getSymbolTable().getHashMap();
        for (Map.Entry entry : map.entrySet()) {
            QName key = (QName)entry.getKey();
            Vector v = (Vector)entry.getValue();
            if (qname != null && !qname.equals(qname)) continue;
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)v.elementAt(i);
                if (!cls.isInstance(symTabEntry)) continue;
                return symTabEntry;
            }
        }
        return null;
    }

    public Port selectPort(Map ports, String portName) throws Exception {
        for (String name : ports.keySet()) {
            if (portName == null || portName.length() == 0) {
                Port port = (Port)ports.get(name);
                List list = port.getExtensibilityElements();
                for (int i = 0; list != null && i < list.size(); ++i) {
                    Object obj = list.get(i);
                    if (!(obj instanceof SOAPAddress)) continue;
                    return port;
                }
                continue;
            }
            if (name == null || !name.equals(portName)) continue;
            return (Port)ports.get(name);
        }
        return null;
    }

    public void explore() {
        int spaces = 0;
        Parser wsdlParser = this.m_definition.getParser();
        SymbolTable symTable = wsdlParser.getSymbolTable();
        HashMap map = wsdlParser.getSymbolTable().getHashMap();
        Iterator iterator = map.entrySet().iterator();
        ++spaces;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            QName key = (QName)entry.getKey();
            Vector v = (Vector)entry.getValue();
            System.out.println();
            System.out.println("**");
            System.out.println(entry.toString());
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)v.elementAt(i);
                if (symTabEntry == null) continue;
                if (symTabEntry instanceof MessageEntry) {
                    System.out.println("* Message Entry:");
                } else if (symTabEntry instanceof BindingEntry) {
                    System.out.println("* Binding Entry:");
                } else if (symTabEntry instanceof ServiceEntry) {
                    System.out.println("* Service Entry:");
                } else if (symTabEntry instanceof DefinedType) {
                    System.out.println("* DefinedType:");
                } else if (symTabEntry instanceof DefinedElement) {
                    System.out.println("* DefinedElement:");
                } else if (symTabEntry instanceof BaseType) {
                    System.out.println("* BaseType:");
                } else if (symTabEntry instanceof PortTypeEntry) {
                    System.out.println("* PortTypeEntry:");
                } else if (symTabEntry instanceof CollectionType) {
                    System.out.println("* CollectionType:");
                } else if (symTabEntry instanceof PortTypeEntry) {
                    System.out.println("* PortTypeEntry:");
                } else if (symTabEntry instanceof PortEntry) {
                    System.out.println("* PortEntry:");
                } else {
                    System.out.println("*? " + symTabEntry.getClass().toString());
                }
                System.out.println(symTabEntry.toString());
            }
        }
        --spaces;
    }

    class Reply {
        String m_portType = null;
        String m_operation = null;
        String m_msgSchema = null;
        String m_msgElement = null;
        String[] m_faults = null;
        boolean m_bAttachments = false;
        Vector m_fields = null;

        public Reply(String portType, String operation, String msgSchema, String msgElement, String[] faults, boolean bAttachments) {
            this.m_portType = portType;
            this.m_operation = operation;
            this.m_msgSchema = msgSchema;
            this.m_msgElement = msgElement;
            this.m_faults = faults;
            this.m_bAttachments = bAttachments;
        }

        void addField(String name, Object type) {
            if (name != null && type != null) {
                if (this.m_fields == null) {
                    this.m_fields = new Vector();
                }
                Object[] param = new Object[]{name, type};
                this.m_fields.add(param);
            }
        }

        Vector getFields() {
            return this.m_fields;
        }

        String getPortTypeName() {
            return this.m_portType;
        }

        String getPortName() {
            return this.m_portType + "Port";
        }

        String getOutputMsgName() {
            return this.m_operation + "Output";
        }

        String getBindingName() {
            return this.m_portType + "SoapBinding";
        }
    }

    class Receive {
        String m_portType = null;
        String m_operation = null;
        String m_msgSchema = null;
        String m_msgElement = null;
        boolean m_bSecurity = false;
        boolean m_bAttachments = false;
        Vector m_fields = null;

        public Receive(String portType, String operation, String msgSchema, String msgElement, boolean bSecurity, boolean bAttachments) {
            this.m_portType = portType;
            this.m_operation = operation;
            this.m_msgSchema = msgSchema;
            this.m_msgElement = msgElement;
            this.m_bSecurity = bSecurity;
            this.m_bAttachments = bAttachments;
        }

        void addField(String name, Object type) {
            if (name != null && type != null) {
                if (this.m_fields == null) {
                    this.m_fields = new Vector();
                }
                Object[] param = new Object[]{name, type};
                this.m_fields.add(param);
            }
        }

        Vector getFields() {
            return this.m_fields;
        }

        String getPortTypeName() {
            return this.m_portType;
        }

        String getPortName() {
            return this.m_portType + "Port";
        }

        String getInputMsgName() {
            return this.m_operation + "Input";
        }

        String getBindingName() {
            return this.m_portType + "SoapBinding";
        }
    }
}

